package cn.com.duiba.cloud.id.generator.client;

import java.util.Map;

/**
 * @author liuyao
 */
public interface IdGeneratorClient {

    /**
     * 生成一个全局唯一的号
     * @param sceneKey 场景标识
     **/
    Long idGenerator(String sceneKey);

    /**
     * 根据sceneKey对应的业务id构建器，生成全局id序列,See:BizIdBuilder
     * @param sceneKey 场景标识
     * @return 业务id
     **/
    String bizIdGenerator(String sceneKey);

    /**
     * 根据sceneKey对应的业务id构建器，生成全局id序列,See:BizIdBuilder
     * @param sceneKey 场景标识
     * @param selfDefinedParameter 自定义参数
     * @return 业务id
     */
    String bizIdGenerator(String sceneKey, Map<String,String> selfDefinedParameter);
}
