package cn.com.duiba.cloud.id.generator.client.configuration;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

/**
 * 发号时间段
 * 按固定的时间量对发号进行重置，重置后，发号将从1开始计数
 * @author liuyao
 */
@Getter
public enum TimeLevel {

    /**
     * 发号不进行时间段的重置
     */
    NONE(""),
    /**
     * 按天进行重置
     */
    DAY("yyyy-MM-dd"),
    /**
     * 按月进行重置
     */
    MONTH("yyyy-MM"),
    /**
     * 按年进行重置
     */
    YEAR("yyyy");

    private final SimpleDateFormat format;

    TimeLevel(String format){
        if(StringUtils.isBlank(format)){
            this.format = null;
        }else {
            this.format = new SimpleDateFormat(format);
        }
    }

    public String formatTime(Date time){
        if(Objects.isNull(format)){
            return "";
        }
        synchronized (format) {
            return format.format(time);
        }
    }

}
