package cn.com.duiba.cloud.id.generator.client.service;

import cn.com.duiba.cloud.id.generator.client.configuration.IdGeneratorProperties;
import org.springframework.scheduling.annotation.Async;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 发号异步加载
 * @author liuyao
 */
public class IdGeneratorAsyncLoadingService {

    @Resource
    private IdGeneratorProperties idGeneratorProperties;

    private ExecutorService executorService;

    @PostConstruct
    public void init(){
        int nThreads = Math.max(idGeneratorProperties.getScenes().size(),1);
        this.executorService = Executors.newFixedThreadPool(nThreads);
    }

    public void executeLoading(IdGeneratorCache cache){
        executorService.execute(cache);
    }


}
