package cn.com.duiba.cloud.id.generator.client.service.builder;

/**
 * 业务Id构造器
 * @author liuyao
 */
public interface BizIdBuilder {

    String DEFAULT_BIZ_ID_BUILDER = "$$default";

    /**
     * 工具方法：在id的前面加 0 补全到 length 对应的长度
     * @param id 全局id
     * @param length 长度
     * @return 补全后的id编码
     */
    default String autoCompleteIdLength(Long id,int length){
        String idStr = id.toString();
        if(idStr.length() >= length){
            return idStr;
        }
        StringBuilder builder = new StringBuilder();
        int def = length - idStr.length();
        for(int i=0;i<def;i++){
            builder.append(0);
        }
        builder.append(id);
        return builder.toString();
    }

    /**
     * 指定支持的发号场景
     */
    String sceneKey();

    /**
     * 构造业务id
     */
    String build(BizIdBuilderParams params);

}
