/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.id.generator.client.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.cloud.id.generator.client.configuration.Scene;
import cn.com.duiba.cloud.id.generator.client.domain.IdGeneratorRequest;
import cn.com.duiba.cloud.id.generator.client.exception.IdGeneratorException;
import cn.com.duiba.cloud.id.generator.client.remoteservice.RemoteIdGeneratorService;
import cn.com.duiba.cloud.id.generator.client.service.IdGeneratorAsyncLoadingService;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class IdGeneratorCache
implements Runnable {
    private final LinkedBlockingQueue<Long> idQueue = new LinkedBlockingQueue();
    private final String ip = NetUtils.getLocalIp();
    private final AtomicBoolean loading = new AtomicBoolean(false);
    private Scene scene;
    private String offsetTime;
    private Long sceneId;
    private int loadingThreshold;
    @Resource
    private RemoteIdGeneratorService remoteIdGeneratorService;
    @Resource
    private IdGeneratorAsyncLoadingService idGeneratorAsyncLoadingService;

    public void init() {
        this.loadingThreshold = this.scene.getStep() / 2;
        this.loadId();
    }

    public Boolean isInvalidate() {
        String time = this.scene.getTimeLevel().formatTime(new Date());
        return !StringUtils.equals((CharSequence)this.offsetTime, (CharSequence)time);
    }

    public Long get() throws IdGeneratorException {
        if (Objects.equals(1, this.scene.getStep())) {
            return this.getByRemote();
        }
        if (this.idQueue.size() < this.loadingThreshold && this.loading.compareAndSet(false, true)) {
            this.idGeneratorAsyncLoadingService.executeLoading(this);
        }
        try {
            return this.idQueue.poll(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IdGeneratorException("\u53d1\u53f7\u8d85\u65f6");
        }
    }

    private Long getByRemote() throws IdGeneratorException {
        IdGeneratorRequest request = new IdGeneratorRequest();
        request.setOffsetTime(this.offsetTime);
        request.setSceneId(this.sceneId);
        request.setIp(this.ip);
        try {
            return this.remoteIdGeneratorService.idGenerator(request);
        }
        catch (BizException e) {
            throw new IdGeneratorException(e.getMessage());
        }
    }

    private void loadId() {
        if (Objects.equals(1L, this.scene.getStep())) {
            return;
        }
        Long mateId = this.getByRemote();
        long start = (mateId - 1L) * (long)this.scene.getStep();
        if (start == 0L) {
            start = 1L;
        }
        long end = mateId * (long)this.scene.getStep();
        for (long i = start; i < end; ++i) {
            this.idQueue.add(i);
        }
        this.loading.set(false);
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public void setOffsetTime(String offsetTime) {
        this.offsetTime = offsetTime;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    @Override
    public void run() {
        this.loadId();
    }
}

