/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.id.generator.client.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.id.generator.client.IdGeneratorClient;
import cn.com.duiba.cloud.id.generator.client.configuration.IdGeneratorProperties;
import cn.com.duiba.cloud.id.generator.client.configuration.Scene;
import cn.com.duiba.cloud.id.generator.client.domain.IdGeneratorKey;
import cn.com.duiba.cloud.id.generator.client.domain.IdGeneratorScene;
import cn.com.duiba.cloud.id.generator.client.exception.IdGeneratorException;
import cn.com.duiba.cloud.id.generator.client.remoteservice.RemoteIdGeneratorService;
import cn.com.duiba.cloud.id.generator.client.service.IdGeneratorCache;
import cn.com.duiba.cloud.id.generator.client.service.builder.BizIdBuilder;
import cn.com.duiba.cloud.id.generator.client.service.builder.BizIdBuilderParams;
import cn.com.duiba.cloud.id.generator.client.service.builder.impl.DefaultBizIdBuilder;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Scheduled;

public class IdGeneratorClientImpl
implements SmartInitializingSingleton,
IdGeneratorClient {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private RemoteIdGeneratorService remoteIdGeneratorService;
    @Resource
    private IdGeneratorProperties idGeneratorProperties;
    @Resource
    private DefaultBizIdBuilder defaultBizIdBuilder;
    @Value(value="${spring.application.name}")
    private String appId;
    private final Map<String, BizIdBuilder> bizIdBuilders = Maps.newConcurrentMap();
    private final Map<String, Long> sceneIdMap = Maps.newConcurrentMap();
    private final LoadingCache<IdGeneratorKey, IdGeneratorCache> cache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<IdGeneratorKey, IdGeneratorCache>(){

        public IdGeneratorCache load(@NonNull IdGeneratorKey key) {
            Long sceneId = (Long)IdGeneratorClientImpl.this.sceneIdMap.get(key.getSceneKey());
            if (Objects.isNull(sceneId)) {
                throw new IdGeneratorException("\u53d1\u53f7\u573a\u666f[" + key.getSceneKey() + "]\u672a\u521d\u59cb\u5316");
            }
            IdGeneratorCache idGeneratorCache = (IdGeneratorCache)IdGeneratorClientImpl.this.applicationContext.getBean(IdGeneratorCache.class);
            idGeneratorCache.setScene(IdGeneratorClientImpl.this.idGeneratorProperties.getScenes().get(key.getSceneKey()));
            idGeneratorCache.setOffsetTime(key.getTime());
            idGeneratorCache.setSceneId(sceneId);
            idGeneratorCache.init();
            return idGeneratorCache;
        }
    });

    @Scheduled(cron="0 0 1/1 * * ?")
    public void scanCache() {
        HashSet keys = Sets.newHashSet();
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            IdGeneratorCache idGeneratorCache = (IdGeneratorCache)entry.getValue();
            if (!idGeneratorCache.isInvalidate().booleanValue()) continue;
            keys.add(entry.getKey());
        }
        for (IdGeneratorKey key : keys) {
            this.cache.invalidate((Object)key);
        }
    }

    public void afterSingletonsInstantiated() {
        ArrayList sceneList = Lists.newArrayList();
        for (Map.Entry<String, Scene> entry : this.idGeneratorProperties.getScenes().entrySet()) {
            Scene scene = entry.getValue();
            IdGeneratorScene item = new IdGeneratorScene();
            item.setSceneKey(entry.getKey());
            item.setAppId(this.appId);
            item.setStep(scene.getStep());
            sceneList.add(item);
        }
        try {
            this.sceneIdMap.putAll(this.remoteIdGeneratorService.initIdGeneratorScene(sceneList));
        }
        catch (BizException e) {
            throw new RuntimeException(e.getMessage());
        }
        Map builderMap = this.applicationContext.getBeansOfType(BizIdBuilder.class);
        for (BizIdBuilder builder : builderMap.values()) {
            String sceneKey = builder.sceneKey();
            if (this.bizIdBuilders.containsKey(sceneKey)) {
                throw new RuntimeException("\u53d1\u53f7\u573a\u666f[" + sceneKey + "]\u5b58\u5728\u591a\u4e2aBizIdBuilder");
            }
            this.bizIdBuilders.put(sceneKey, builder);
        }
    }

    private Long generator(String sceneKey, Date time) {
        Scene scene = this.idGeneratorProperties.getScenes().get(sceneKey);
        if (Objects.isNull(scene)) {
            throw new IdGeneratorException("\u53d1\u53f7\u573a\u666f[" + sceneKey + "]\u672a\u914d\u7f6e");
        }
        String formatTime = scene.getTimeLevel().formatTime(time);
        IdGeneratorKey key = new IdGeneratorKey();
        key.setSceneKey(sceneKey);
        key.setTime(formatTime);
        IdGeneratorCache idGeneratorCache = (IdGeneratorCache)this.cache.get((Object)key);
        return Objects.requireNonNull(idGeneratorCache).get();
    }

    @Override
    public Long idGenerator(String sceneKey) {
        return this.generator(sceneKey, new Date());
    }

    @Override
    public String bizIdGenerator(String sceneKey) {
        return this.bizIdGenerator(sceneKey, Collections.emptyMap());
    }

    @Override
    public String bizIdGenerator(String sceneKey, Map<String, String> selfDefinedParameter) {
        BizIdBuilder builder = this.bizIdBuilders.getOrDefault(sceneKey, this.defaultBizIdBuilder);
        Date time = new Date();
        Long id = this.generator(sceneKey, time);
        BizIdBuilderParams params = new BizIdBuilderParams();
        params.setId(id);
        params.setSelfDefinedParameter(selfDefinedParameter);
        params.setTime(time);
        return builder.build(params);
    }
}

