# 发号器文档

## 1.介绍
发号器用于获取全局唯一的id,使用场景一般为生成全局唯一的流水号。新的发号器以场景维度进行发号计量，发号场景的标识先申请先使用。
场景数相比老的发号器来说没有数量限制，且性能更加优秀

接入方式
```
compile "cn.com.duiba.cloud:id-generator-client:0.0.1"
```

## 2.配置

**发号步长**:客户端每次向远程申请一个全局mateId（源id），在客户端会根据步长创建相应个数的发号缓存，步长越大，性能越好。  
但是对机器的内存开销会很大，建议： 1000 - 10000  
**发号重置时间**：对于一些时间相关的发号场景，要求发号器在经历过一个特定的时间段后，发号器重新从1开始发号，  
如配置为 DAY，发号器会在每天的0时0分进行重置
```
NONE:不重置，默认
DAY：按天重置
MONTH：按月重置
YEAR：按年重置
```
配置格式
```
duiba.cloud.id-generator.scenes.[发号场景].step = 发号步长
duiba.cloud.id-generator.scenes.[发号场景].time-level = 发号重置时间
```
示例：定义两个场景
```
duiba.cloud.id-generator.scenes.test.step = 2000
duiba.cloud.id-generator.scenes.test.time-level = DAY

duiba.cloud.id-generator.scenes.test2.step = 1000
duiba.cloud.id-generator.scenes.test2.time-level = NONE
```

## 3.使用

```
    @Resource
    private IdGeneratorClient idGeneratorClient;
    
    public String oneId(){
        Long id = idGeneratorClient.idGenerator("test");
        return "code:"+id;
    }
```

## 4.业务Id构造器
通常情况下，我们会使用全局id构建一个业务单流水号，发号器客户端内置了业务Id构造接口：BizIdBuilder  
通过实现BizIdBuilder接口，再将实现类注册到IOC  
最后调用 idGeneratorClient.bizIdGenerator() 即可按自定义的Builder生成业务id号

```
@RestController
public class TestController implements BizIdBuilder {

    @Resource
    private IdGeneratorClient idGeneratorClient;

    @RequestMapping("/bizId")
    public String bizId(){
        Map<String,String> params = Maps.newHashMap();
        params.put("prefix","CZ");
        return "code："+idGeneratorClient.bizIdGenerator("test",params);
    }


    @Override
    public String sceneKey() {
        return "test";
    }

    @Override
    public String build(BizIdBuilderParams params) {
        Map<String,String> selfDefinedParameter = params.getSelfDefinedParameter();
        return selfDefinedParameter.get("prefix") + "-" +
                DateUtils.getDayNumber(params.getTime()) +
                autoCompleteIdLength(params.getId(), 10);
    }
}
```
