package cn.com.duiba.cloud.manage.service.api.model.enums;

/**
 * @program: duiba-manage-service
 * @description: 业务主体枚举
 * @author: 郭云龙
 * @create: 2022-03-24 16:22
 **/
public enum BusinessEntityEnum {
    DUI_BA(1L,"兑吧"),
    DUI_A(2L,"兑啊"),
    DUI_JIE(3L,"兑捷"),
    ;
    /**
     * 业务主体ID
     */
    private Long businessEntityId;
    /**
     * 业务主体名称
     */
    private String businessEntityName;

    BusinessEntityEnum(Long businessEntityId, String businessEntityName) {
        this.businessEntityId = businessEntityId;
        this.businessEntityName = businessEntityName;
    }

    public Long getBusinessEntityId() {
        return businessEntityId;
    }

    public String getBusinessEntityName() {
        return businessEntityName;
    }

    public static String getNameById(Long id) {
        for (BusinessEntityEnum entity : BusinessEntityEnum.values()) {
            if (entity.businessEntityId.equals(id)) {
                return entity.businessEntityName;
            }
        }
        return null;
    }
}
