package cn.com.duiba.cloud.manage.service.api.model.enums.audit;

import lombok.Getter;

/**
 * @program: duiba-manage-service
 * @description: 审核状态 0-待审核 1-审核通过 2-审核拒绝
 * @author: 郭云龙
 * @create: 2021-11-08 10:53
 **/

@Getter
public enum AuditStateEnum {
    REVIEW("0","审核中"),
    PASS("1","审核通过"),
    REFUSE("2","审核拒绝"),
    REVOKE("3","撤销审核"),
    ;

    private String key;
    private String value;
    AuditStateEnum(String key, String value) {
        this.key = key;
        this.value = value;
    }
}
