package cn.com.duiba.cloud.manage.service.api.model.enums.exportrecord;

import java.util.Objects;

/**
 * @author linzhou
 * @ClassName ImportDataTypeEnum.java
 * @createTime 2021年11月03日 19:40:00
 * @Description
 */
public enum ExportDataTypeEnum {
    STAFF_INVITE_EXPORT(0,"员工邀请列表导出"),
    STAFF_EXPORT(1,"员工导出"),
    ROLE_STAFF_INVITE(2,"角色员工导出"),
    ORDER_EXPORT(3, "订单导出"),
    COUPON_EXPORT_IMPORT(4, "卡券库导入导出"),
    SIGNUP_ANSWER_EXPORT(5, "报名活动答卷导出"),
    CONSUMER_CREDIT_FLOW_EXPORT(6, "积分明细导出"),
    CONSUMER_INFO_EXPORT(7, "C端用户信息导出"),
    PAY_BILL_EXPORT(8, "资金明细导出"),
    ORDER_MNG_EXPORT(9, "兑吧管理后台订单导出"),
    ORDER_DELIVERY_EXPORT(10, "兑吧管理后台订单待发货导出"),
    ORDER_ERROR_EXPORT(11, "兑吧管理后台异常订单导出"),
    CONSUMER_GROWTH_VALUE_FLOW_EXPORT(12, "用户成长值明细导出"),

    ;

    /**
     *
     */
    private Integer type;
    /**
     * 描述
     */
    private String desc;

    ExportDataTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ExportDataTypeEnum getExportDataTypeEnum(Integer type){
        for (ExportDataTypeEnum value : ExportDataTypeEnum.values()) {
            if (Objects.equals(value.getType(),type)){
                return value;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
