package cn.com.duiba.cloud.manage.service.api.model.enums.operation.assistant.shortlink;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 短链明细状态枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 21:12
 * @since 0.0.7
 **/
@Getter
@AllArgsConstructor
public enum ShortLinkDetailEnum implements IEnum<Integer> {
    /**
     * 成功
     */
    SUCCESS(1, "处理成功"),

    /**
     * 失败
     */
    FAIL(2, "处理失败"),

    /**
     * 处理中
     */
    HANDLER(3, "处理中"),
    ;

    /**
     * 状态id
     */
    private Integer dbCode;

    /**
     * 业务类型描述
     */
    private String desc;
}
