package cn.com.duiba.cloud.manage.service.api.model.param.importdata;

import cn.com.duiba.cloud.manage.service.api.model.enums.importdata.ImportDataTypeEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 导入记录保存
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/22 4:28 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class RemoteImportSaveRequest extends BaseParam {
    private static final long serialVersionUID = -3268254079136881311L;
    /**
     * 导入类型 1-员工导入 2-角色员工导入 3、用户信息导入
     * @see ImportDataTypeEnum
     */
    private Integer importType;

    /**
     * 上传文件名称
     */
    private String fileName;

    /**
     * 上传文件url
     */
    private String importFileUrl;

    /**
     * 导入数量
     */
    private Integer totalNum;

    /**
     * 状态 0-处理完毕 1-处理中
     */
    private Integer state;

    /**
     * 操作人->租户管理员
     */
    private Long createdBy;

    /**
     * 修改人
     */
    private Long modifiedBy;

}
