package cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 编辑页面
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteMallAppPageEditParam extends BaseParam {

    private static final long serialVersionUID = -4947409099563517410L;

    /**
     * 页面id
     */
    @NotNull(message = "页面id不能为空")
    private Long id;

    /**
     * 页面名称
     */
    @Size(max = 10, message = "页面名称不能超过10个字符")
    private String pageTitle;

    /**
     * 页面内容
     */
    private String pageContent;


}
