package cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * 分页查询生成短链明细请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 13:46
 * @since 0.0.7
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemotePageListShortLinkDetailParam extends PageRequest {
    private static final long serialVersionUID = -7957138772592736784L;

    /**
     * 任务id
     */
    @NotNull(message = "任务id不能为空")
    private Long taskId;

    /**
     * 转换状态(1:成功,2:失败,3:处理中)
     */
    private Integer conversionStatus;

    /**
     * 分页查询时，是否需要查询总数<br>
     * 默认false，不查询
     */
    private Boolean isSearchCount = false;
}
