package cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 插入短链明细请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 10:05
 * @since 0.0.7
 **/
@Data
@Accessors(chain = true)
public class RemoteSaveShortLinkDetailParam implements Serializable {
    private static final long serialVersionUID = -1772021905359726870L;

    /**
     * 任务id
     */
    @NotNull(message = "任务id不能为空")
    private Long taskId;

    /**
     * 原生链接
     */
    @NotBlank(message = "原生链接不能为空")
    private String nativeLink;
}
