package cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 修改短链任务请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 10:29
 * @since 0.0.7
 **/
@Data
@Accessors(chain = true)
public class RemoteUpdateShortLinkTaskParam implements Serializable {
    private static final long serialVersionUID = -8377517474283310569L;

    /**
     * 任务id
     */
    @NotNull(message = "任务id不能为空")
    private Long id;

    /**
     * 导入数量
     */
    private Long importNum;

    /**
     * 转换成功数
     */
    private Long conversionSuccessNum;

    /**
     * 转换失败数
     */
    private Long conversionFailNum;

    /**
     * 任务状态(1:已完成,2:转换中,3:生成中,4:已生成)
     */
    private Integer taskStatus;

    /**
     * 导出文件地址
     */
    private String exportFileUrl;
}
