package cn.com.duiba.cloud.manage.service.api.model.param.rights;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/3/30 14:45
 */
@Getter
@Setter
public class RemoteOpenRecordAddParam implements Serializable {

    /**
     * 服务类型ID
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.ServiceTypeEnum
     */
    @NotNull(message = "服务类型不能为空")
    private Long serviceTypeId;

    /**
     * 订阅应用ID
     */
    @NotNull(message = "订阅应用id不能为空")
    private Long tenantAppId;

    /**
     * 套餐版本/售卖包ID
     */
    @NotNull(message = "套餐版本/售卖包ID不能为空")
    private Long rightsPkgId;

    /**
     * 服务时长ID
     */
    @NotNull(message = "服务时长不能为空")
    private Long serviceTimeId;

    /**
     * 服务开始日期
     */
    private Date serviceStartDate;

    /**
     * 赠送时长, 非自定义服务时长必填
     */
    private Long giftDuration;

    /**
     * 服务结束日期
     */
    @NotNull(message = "服务结束日期不能为空")
    private Date serviceEndDate;

    /**
     * 操作的innerUserId
     */
    @NotNull(message = "操作人id不能为空")
    private Long innerUserId;
}
