package cn.com.duiba.cloud.manage.service.api.model.param.store;

import cn.com.duiba.cloud.manage.service.api.model.enums.store.ShelfStateEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import cn.com.duiba.cloud.manage.service.api.utils.EnumValid;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/12 11:06
 */
@Getter
@Setter
public class RemoteStoreDiscountEnableOrDisableParam extends BaseParam {

    /**
     * 门店优惠id
     */
    @NotNull(message = "门店优惠id不能为空")
    private Long id;

    /**
     * 上架状态 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.ShelfStateEnum}
     */
    @NotNull(message = "上架状态不能为空")
    @EnumValid(target = ShelfStateEnum.class, message = "上架状态不合法")
    private Integer state;
}
