package cn.com.duiba.cloud.manage.service.api.remoteservice.customerService;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.customer.CustomerServiceRuleDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ClassName:RemoteCustomerServiceRuleService<br/>
 **/
@AdvancedFeignClient
public interface RemoteCustomerServiceRuleService {

    /**
     * 根据唯一索引查询配置
     *
     * @param appId
     * @param ruleType
     * @param activityType
     * @return
     */
    CustomerServiceRuleDto findByKey(Long appId) throws BizException;


    /**
     * 修改流量配置
     * appId, ruleType, activityType必填
     * validRegions和validPeriod没有修改时传递旧值
     *
     * @param activityFlowRuleDto
     * @return
     */
    Boolean update(CustomerServiceRuleDto activityFlowRuleDto);

    /**
     * 批量更新
     *
     * @param activityFlowRuleDtos
     * @return
     */
    List<Boolean> updateList(List<CustomerServiceRuleDto> activityFlowRuleDtos);

    /**
     * 新增流量配置
     *
     * @param activityFlowRuleDto
     * @return
     */
    Long insert(CustomerServiceRuleDto activityFlowRuleDto);


    /**
     * 根据唯一索引查询配置
     *
     * @param appIds
     * @param ruleType
     * @param activityType
     * @return
     */
    Map<Long, CustomerServiceRuleDto> findListByAppIds(Set<Long> appIds);


}
