package cn.com.duiba.cloud.manage.service.api.remoteservice.operation.assistant.shortlink;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.operation.assistant.shortlink.ShortLinkDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.operation.assistant.shortlink.ShortLinkTaskDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink.RemoteCountShortLinkDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink.RemotePageListShortLinkDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink.RemotePageListShortLinkTaskParam;
import cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink.RemoteSaveShortLinkDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink.RemoteSaveShortLinkTaskParam;
import cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink.RemoteUpdateShortLinkDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink.RemoteUpdateShortLinkTaskParam;
import cn.com.duiba.wolf.entity.PageResponse;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 短链服务remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 09:55
 * @since 0.0.7
 **/
@AdvancedFeignClient
public interface RemoteAssistantShortLinkService {
    /**
     * 批量新增生成短链明细
     *
     * @param remoteSaveShortLinkDetailParamList 插入短链明细请求参数
     * @return 插入数量
     */
    int batchSaveShortLinkDetail(
            @Valid @NotNull(message = "插入短链明细请求参数不能为空")
            @Size(min = 1, max = 200, message = "插入短链明细请求参数参数大小必须在1-200之间")
                    List<RemoteSaveShortLinkDetailParam> remoteSaveShortLinkDetailParamList);

    /**
     * 批量修改生成短链明细
     *
     * @param remoteUpdateShortLinkDetailParamList 修改短链明细请求参数
     * @return true/false
     * @throws BizException 短链重复
     */
    boolean batchUpdateShortLinkDetail(
            @Valid @NotNull(message = "修改短链明细请求参数不能为空")
            @Size(min = 1, max = 200, message = "修改短链明细请求参数参数大小必须在1-200之间")
                    List<RemoteUpdateShortLinkDetailParam> remoteUpdateShortLinkDetailParamList) throws BizException;

    /**
     * 保存生成短链任务
     *
     * @param remoteSaveShortLinkTaskParam 插入短链任务请求参数
     * @return 任务id
     * @throws BizException db新增失败
     */
    Long saveShortLinkTask(RemoteSaveShortLinkTaskParam remoteSaveShortLinkTaskParam) throws BizException;

    /**
     * 修改生成短链任务
     *
     * @param remoteUpdateShortLinkTaskParam 修改短链任务请求参数
     * @return true/false
     */
    boolean updateShortLinkTask(RemoteUpdateShortLinkTaskParam remoteUpdateShortLinkTaskParam);

    /**
     * 分页查询生成短链任务列表
     *
     * @param remotePageListShortLinkTaskParam 分页查询生成短链任务请求参数
     * @return 短链任务DTO
     * @throws BizException 参数错误
     */
    PageResponse<ShortLinkTaskDTO> pageListShortLinkTask(
            RemotePageListShortLinkTaskParam remotePageListShortLinkTaskParam) throws BizException;

    /**
     * 根据任务id查询生成短链任务
     *
     * @param id 任务id
     * @return 短链任务DTO
     */
    ShortLinkTaskDTO findShortLinkTaskById(@NotNull(message = "任务id不能为空") Long id);

    /**
     * 分页查询生成短链明细列表
     *
     * @param remotePageListShortLinkDetailParam 分页查询生成短链明细请求参数
     * @return 短链明细DTO
     * @throws BizException 参数错误
     */
    PageResponse<ShortLinkDetailDTO> pageListShortLinkDetail(
            RemotePageListShortLinkDetailParam remotePageListShortLinkDetailParam) throws BizException;

    /**
     * 根据任务id统计明细总数
     *
     * @param remoteCountShortLinkDetailParam 统计任务明细总数请求参数
     * @return 明细总数
     */
    long countShortLinkDetail(RemoteCountShortLinkDetailParam remoteCountShortLinkDetailParam);

    /**
     * 根据短链获取原链<br>
     * 短链一旦生成，即跟原链永久绑定，上层业务应该自己对映射关系做缓存处理
     *
     * @param shortLink 短链
     * @return 原链
     */
    String getNativeLinkByShortLink(@NotBlank(message = "短链不能为空") String shortLink);

    /**
     * 根据长链生成短链
     *
     * @param generateSize 生成短链数量
     * @return 短链
     */
    List<String> generateShortLink(
            @NotNull(message = "生成短链数量不能为空")
            @Range(min = 1, max = 200, message = "生成短链数量大小必须在1-200之间") Integer generateSize);
}
