package cn.com.duiba.cloud.manage.service.api.remoteservice.tenant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.IndexChooseDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.TenantDbDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.TenantInfoDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.UserIndexDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.UserInfoDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteCreateTenantParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteDealInviteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteLeaveTenantParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteTenantAppIdsParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteTenantInfoParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteTenantNameParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteTenantNoParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteTenantPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteUserIndexParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;
import java.util.Map;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/11/5 10:17
 */
@AdvancedFeignClient
public interface RemoteTenantService {

    /**
     * 权限视图选择查询接口
     * @param param 参数
     * @return IndexChooseDTO
     * @throws BizException 业务异常
     */
    IndexChooseDTO indexChoose(BaseParam param) throws BizException;

    /**
     * 创建租户
     * @param param 请求参数
     * @return 租户id
     * @throws BizException e
     */
    Long createTenant(RemoteCreateTenantParam param) throws BizException;

    /**
     * 租户首页信息
     * @param param 查询参数
     * @return UserIndexDTO
     * @throws BizException e
     */
    UserIndexDTO userIndex(RemoteUserIndexParam param) throws BizException;

    /**
     * 个人账号信息接口
     * @param param 查询参数
     * @return UserInfoDTO
     * @throws BizException e
     */
    UserInfoDTO userInfo(BaseParam param) throws BizException;

    /**
     * 租户账号信息查询
     * @param param 查询参数
     * @return TenantInfoDTO
     * @throws BizException e
     */
    TenantInfoDTO tenantInfo(BaseParam param) throws BizException;

    /**
     * 修改租户账号信息
     * @param param 修改参数
     * @throws BizException e
     */
    void updateTenantInfo(RemoteTenantInfoParam param) throws BizException;

    /**
     * 处理邀请接口
     * @param param 参数
     * @throws BizException e
     */
    void dealInvite(RemoteDealInviteParam param) throws BizException;

    /**
     * 退出租户
     * @param param 参数
     * @throws BizException e
     */
    void leaveTenant(RemoteLeaveTenantParam param) throws BizException;

    /**
     * 获取上次登录的租户id
     * @param baseParam 参数
     * @return 上次登录的租户id
     * @throws BizException e
     */
    Long getLastLoginTenantId(BaseParam baseParam) throws BizException;

    /**
     * 保存上次登录的租户id
     * @param baseParam 参数
     * @throws BizException e
     */
    void saveLastLoginTenantId(BaseParam baseParam) throws BizException;

    /**
     * 批量获取租户信息
     * @param tenantIds
     * @return
     */
    List<TenantDbDTO> selectListByIds(List<Long> tenantIds);

    /**
     * 通过租户id批量查询名称
     * @param param 租户id list
     * @return 租户名称 map
     */
    Map<Long, String> getTenantNameMap(RemoteTenantNameParam param);

    /**
     * 根据企业编号查询企业信息
     * @return
     */
    Long selectTenantIdByNo(RemoteTenantNoParam remoteTenantNoParam) throws BizException;

    /**
     * 根据租户应用id获取租户信息map
     * @param param 租户应用id list
     * @return Map<Long, TenantDbDTO>
     */
    Map<Long, TenantDbDTO> selectListByTenantAppIds(RemoteTenantAppIdsParam param);

    /**
     * 租户分页查询
     *
     * @param remoteParam  入参
     * @return list
     * @throws BizException 业务异常
     */
    PageResponse<TenantInfoDTO> pageQuery(RemoteTenantPageQueryParam remoteParam) throws BizException;

}