package cn.com.duiba.cloud.manage.service.api.strategy;


import lombok.Getter;

/**
 * @author guoyunlong
 */

@Getter
public enum AuditStrategy {
    //自动审核，自动通过审核
    AUTO(1,"自动审核"),
    //通过人工进行审核
    NON_AUTO(2,"人工审核"),
    //后续有可能对接AI智能审核策略
    AI(3,"智能审核");

    private Integer id;
    private String value;
    AuditStrategy(int id, String value) {
        this.id = id;
        this.value = value;
    }

    /**
     * 根据ID匹配审核策略
     * @param id
     * @return
     */
    public static AuditStrategy matchId(Integer id ) {
        for (AuditStrategy auditStrategy : AuditStrategy.values()) {
            if (auditStrategy.id.equals(id)) {
                return auditStrategy;
            }
        }
        //未匹配上的策略一律走人工审核
        return AuditStrategy.NON_AUTO;
    }
}
