/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.cloud.manage.service.api.utils.Code;
import cn.com.duiba.cloud.manage.service.api.utils.EnumUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import javax.validation.constraints.NotNull;

public enum ServiceTimeEnum {
    ONE_YEAR(1L, "1\u5e74", UnitEnum.Y.name(), 1),
    SEVEN_DAYS(7L, "7\u5929", UnitEnum.D.name(), 7),
    CUSTOMIZE(99L, "\u81ea\u5b9a\u4e49");

    @Code
    private Long serviceTimeId;
    private String serviceTimeName;
    private String unit;
    private Integer duration;

    private ServiceTimeEnum(Long serviceTimeId, String serviceTimeName, String unit, Integer duration) {
        this.serviceTimeId = serviceTimeId;
        this.serviceTimeName = serviceTimeName;
        this.unit = unit;
        this.duration = duration;
    }

    private ServiceTimeEnum(Long serviceTimeId, String serviceTimeName) {
        this.serviceTimeId = serviceTimeId;
        this.serviceTimeName = serviceTimeName;
    }

    public Long getServiceTimeId() {
        return this.serviceTimeId;
    }

    public String getServiceTimeName() {
        return this.serviceTimeName;
    }

    public String getUnit() {
        return this.unit;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public static String getNameById(Long id) {
        return Arrays.stream(ServiceTimeEnum.values()).filter(o -> id.equals(o.getServiceTimeId())).findFirst().orElse(CUSTOMIZE).getServiceTimeName();
    }

    public static LocalDateTime addTime(@NotNull Long serviceTypeId, @NotNull LocalDateTime startTime, LocalDateTime endTime, Long giftTime) throws BizException {
        LocalDateTime result;
        ServiceTimeEnum.checkStartTime(startTime);
        giftTime = giftTime == null ? 0L : giftTime;
        ServiceTimeEnum serviceTimeEnum = EnumUtil.getEnum(ServiceTimeEnum.class, serviceTypeId);
        Conditions.expectTrue((serviceTimeEnum != null ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u7684\u670d\u52a1\u65f6\u957f\u7c7b\u578b");
        switch (serviceTimeEnum) {
            case ONE_YEAR: {
                result = startTime.plusYears(1L).plusDays(giftTime);
                break;
            }
            case SEVEN_DAYS: {
                result = startTime.plusDays(7L).plusDays(giftTime);
                break;
            }
            case CUSTOMIZE: {
                Conditions.expectTrue((endTime != null ? 1 : 0) != 0, (String)"\u670d\u52a1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                result = endTime;
                break;
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u670d\u52a1\u65f6\u957f\u7c7b\u578b");
            }
        }
        return result;
    }

    public static void checkStartTime(LocalDateTime startTime) throws BizException {
        LocalDateTime todayStartTime = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        Conditions.expectTrue((startTime.isAfter(todayStartTime) || startTime.equals(todayStartTime) ? 1 : 0) != 0, (String)"\u670d\u52a1\u5f00\u59cb\u65f6\u95f4\u53ea\u80fd\u9009\u62e9\u4eca\u5929\u6216\u4eca\u5929\u4e4b\u540e\u7684\u65e5\u671f");
    }

    static enum UnitEnum {
        Y,
        M,
        D;

    }
}

