/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.enums.app;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;

public enum TenantAppStateEnum {
    NOT_START(0, "\u672a\u5f00\u59cb"),
    NORMAL(1, "\u6b63\u5e38"),
    EXPIRED(2, "\u8fc7\u671f");

    private Integer state;
    private String desc;

    private TenantAppStateEnum(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return this.state;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getDescByState(Integer state) {
        for (TenantAppStateEnum entity : TenantAppStateEnum.values()) {
            if (!entity.state.equals(state)) continue;
            return entity.desc;
        }
        return null;
    }

    public static Integer getStateByTime(Date startTime, Date endTime) {
        if (!ObjectUtils.allNotNull((Object[])new Object[]{startTime, endTime})) {
            return null;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        return TenantAppStateEnum.getStateByTime(startTime.toInstant().atZone(zoneId).toLocalDateTime(), endTime.toInstant().atZone(zoneId).toLocalDateTime());
    }

    public static Integer getStateByTime(LocalDateTime startTime, LocalDateTime endTime) {
        if (!ObjectUtils.allNotNull((Object[])new Object[]{startTime, endTime})) {
            return null;
        }
        if (endTime.compareTo(startTime) < 0) {
            throw new IllegalStateException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.compareTo(startTime) < 0) {
            return TenantAppStateEnum.NOT_START.state;
        }
        if (now.compareTo(endTime) <= 0) {
            return TenantAppStateEnum.NORMAL.state;
        }
        return TenantAppStateEnum.EXPIRED.state;
    }
}

