/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.model.enums.tenant.RsTenantStateEnum;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.api.utils.Code;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;

public class EnumUtil {
    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, Object code) throws BizException {
        Enum[] values = EnumUtil.values(enumClass);
        Field field = EnumUtil.getCodeField(enumClass);
        AssertUtil.isNotNull(field, ErrorCode.ENUM_UTIL_GET_FIELD_IS_NULL, new Object[0]);
        field.setAccessible(true);
        if (Objects.nonNull(values)) {
            for (Enum value : values) {
                Object o = EnumUtil.getFieldValue(field, value);
                if (!Objects.nonNull(o) || !Objects.equals(code, o)) continue;
                return (T)value;
            }
        }
        return null;
    }

    public static <T extends Enum<T>> T getEnumDefaultNull(Class<T> enumClass, Object code) {
        try {
            return EnumUtil.getEnum(enumClass, code);
        }
        catch (BizException e) {
            return null;
        }
    }

    private static Object getFieldValue(Field field, Object o) {
        try {
            return field.get(o);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static <T extends Enum<T>> Field getCodeField(Class<T> enumClass) {
        for (Field field : enumClass.getDeclaredFields()) {
            Code code = field.getAnnotation(Code.class);
            String name = field.getName();
            if (!Objects.nonNull(code) && !"code".equals(name)) continue;
            return field;
        }
        return null;
    }

    private static <E extends Enum<E>> E[] values(Class<E> enumClass) {
        try {
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            Object valuesObj = valuesMethod.invoke(enumClass, new Object[0]);
            Enum[] values = (Enum[])valuesObj;
            return values;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) throws BizException {
        RsTenantStateEnum anEnum = EnumUtil.getEnum(RsTenantStateEnum.class, 1);
        RsTenantStateEnum anEnum2 = EnumUtil.getEnum(RsTenantStateEnum.class, 2);
        RsTenantStateEnum anEnum3 = EnumUtil.getEnum(RsTenantStateEnum.class, 3);
        RsTenantStateEnum anEnum4 = EnumUtil.getEnum(RsTenantStateEnum.class, 4);
    }
}

