package cn.com.duiba.cloud.manage.service.api.model.dto.dictionary;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * tb_dictionary
 *
 * @author
 */
@Data
public class DictionaryDTO implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 数据类型 1:行业类型
     */
    private Integer dataType;

    /**
     * 数据编码
     */
    private String code;

    /**
     * 数据数据名称
     */
    private String name;

    /**
     * 上级id
     */
    private Long parentId;

    /**
     * 数据路径,所有上级id按顺序排列用&字符包裹 例如:&1&3&25&67&
     */
    private String path;

    /**
     * 状态 0-停用 1-启用
     */
    private Integer state;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改人
     */
    private Long modifiedBy;
    /**
     * 子数据集
     */
    private List<DictionaryDTO> childList;

    private static final long serialVersionUID = 1L;

    public void addChild(DictionaryDTO child){
        if (Objects.isNull(child)){
            return;
        }
        if (Objects.isNull(childList)){
            childList = new ArrayList<>();
        }
        childList.add(child);
    }
}