package cn.com.duiba.cloud.manage.service.api.model.dto.mallapp;

import lombok.Data;

import java.io.Serializable;

/**
 * @author: 郑建豪
 * @date: 2022/3/28 15:54
 * @description: 商城应用分享配置
 */
@Data
public class MallAppShareConfDTO implements Serializable {

    private static final long serialVersionUID = -6015436305669819043L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 商城应用id
     */
    private Long appId;

    /**
     * 分享图标
     */
    private String shareLogo;

    /**
     * 分享按钮名称
     */
    private String shareButtonName;

    /**
     * 唤起打开应用的链接
     */
    private String wakeupAppLink;

    /**
     * 安卓分享链接
     */
    private String shareAndroidLink;

    /**
     * 苹果分享链接
     */
    private String shareIosLink;

    /**
     * 开发者配置ios分享代码
     */
    private String shareIosCode;

    /**
     * 开发者配置android分享代码
     */
    private String shareAndroidCode;

    /**
     * 唤端类型：0，兑吧唤端页；1，开发者唤端页
     */
    private Integer callUpType;

    /**
     * 开发者唤端页路径
     */
    private String developerCustomCallUpPage;

    /**
     * ios唤端链接
     */
    private String iosDeepLink;

    /**
     * android唤端链接
     */
    private String androidDeepLink;

}