package cn.com.duiba.cloud.manage.service.api.model.dto.mallapp;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhengjianhao
 * @date 2022/3/28
 * @description 商城应用会员等级配置
 */
@Data
public class MallAppVipGradeDTO implements Serializable {

	private static final long serialVersionUID = 7580922952408785079L;

	/**
	 * 主键id
	 */
	private Long id;

	/**
	 * 商城应用id
	 */
	private Long appId;

	/**
	 * 等级权重
	 */
	private Integer grade;

	/**
	 * 等级标识
	 */
	private String devTag;

	/**
	 * 等级名称
	 */
	private String name;

	/**
	 * 等级图标
	 */
	private String icon;

	/**
	 * 升级规则：升级需要的成长值
	 */
	private Long upgradeGrowthValue;

	/**
	 * 是否启用降级：0，不启用；1，启用
	 */
	private Integer openRelegation;

	/**
	 * 降级规则：等级有效期内成长值未达到该配置，将在到期时进行降级
	 */
	private Long demotionValue;

	/**
	 * 成员人数
	 */
	private Long memberCount;

}
