package cn.com.duiba.cloud.manage.service.api.model.dto.rights;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 应用权益详情
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/24
 */
@Getter
@Setter
public class AppRightsDetailDTO implements Serializable {

    private static final long serialVersionUID = 8746702732187209900L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 权益名称
     */
    private String rightsName;

    /**
     * 权益对应的code
     */
    private String rightsCode;

    /**
     * 权益内容，json格式
     */
    private String rightsContent;

    /**
     * 父级权益id
     */
    private Long parentId;

    /**
     * 状态 0-不可用 1-可用
     */
    private Integer state;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 优先级
     */
    private Integer level;

    /**
     * 权限列表
     */
    private List<Long> authList;

}
