package cn.com.duiba.cloud.manage.service.api.model.enums;

import java.util.Arrays;

/**
 * @program: duiba-manage-service
 * @description: 套餐版本售卖包状态枚举
 * @author: 郭云龙
 * @create: 2022-03-24 15:26
 **/
public enum RightsStatusEnum {
    /**
     *
     */
    DISABLE((byte) 0, "停用"),
    ENABLE((byte) 1, "启用"),
    ;

    /**
     * 状态ID
     */
    private Byte rightsStatusId;

    /**
     * 状态名称
     */
    private String rightsStatusName;

    RightsStatusEnum(Byte rightsStatusId, String rightsStatusName) {
        this.rightsStatusId = rightsStatusId;
        this.rightsStatusName = rightsStatusName;
    }

    public Byte getRightsStatusId() {
        return rightsStatusId;
    }

    public String getRightsStatusName() {
        return rightsStatusName;
    }


    public static String getNameById(Byte id){
        return Arrays.stream(RightsStatusEnum.values())
                .filter(o -> id.equals(o.getRightsStatusId()))
                .findFirst().orElse(null)
                .getRightsStatusName();
    }
}
