package cn.com.duiba.cloud.manage.service.api.model.enums;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description 租户状态
 * @date 2021/11/9 12:05
 */
public enum TenantAppTagEnum {

    DEFAULT_TAG(0L,"无标签"),
    CUSTOMER_TEST(1L,"客户测试"),
    CUSTOMER_PROD(2L,"客户生产"),
    INNER_TEST(3L,"内部测试"),
    ;


    /**
     * 订阅应用标签ID
     */
    private Long tenantAppTagId;
    /**
     * 订阅应用标签名称
     */
    private String tenantAppTagName;

    TenantAppTagEnum(Long tenantAppTagId, String tenantAppTagName) {
        this.tenantAppTagId = tenantAppTagId;
        this.tenantAppTagName = tenantAppTagName;
    }

    public Long getTenantAppTagId() {
        return tenantAppTagId;
    }

    public String getTenantAppTagName() {
        return tenantAppTagName;
    }

    public static String getNameById(Long id) {
        for (TenantAppTagEnum entity : TenantAppTagEnum.values()) {
            if (entity.tenantAppTagId.equals(id)) {
                return entity.tenantAppTagName;
            }
        }
        return null;
    }
}
