package cn.com.duiba.cloud.manage.service.api.model.enums.app;

import java.util.Arrays;

/**
 * @Author: fss
 * @Date: 2022/6/1 16
 * @Description: 推送开关位
 */
public enum AppOrderPushEnum {


    WAIT_PAY_PUSH(0, 10, "待支付推送"),
    WAIT_REVIEW_PUSH(1, 20, "待审核推送"),
    WAIT_SHIPMENT_PUSH(2, 30, "待发货推送"),
        WAIT_TAKE_DELIVERY_PUSH(3,40, "待收货推送"),
    ORDER_COMPLETION_PUSH(4, 50, "交易完成推送"),

    ORDER_ERROR_PUSH(5, 89, "异常状态推送"),

    ORDER_SUCCESS_PUSH(6, 90, "交易成功推送"),
    ORDER_CLOSE_PUSH(7, 91, "交易关闭推送"),
    ;

    private final int perm;
    private final int orderStatus;
    private final String desc;

    AppOrderPushEnum(int perm, int orderStatus, String desc) {
        this.perm = perm;
        this.orderStatus = orderStatus;
        this.desc = desc;
    }

    public static AppOrderPushEnum getByOrderStatus(int orderStatus) {
        return Arrays.stream(AppOrderPushEnum.values()).filter(e -> orderStatus == e.orderStatus).findFirst().orElse(null);
    }

    public int getOrderStatus() {
        return orderStatus;
    }

    public int getPerm() {
        return perm;
    }


    public String getDesc() {
        return desc;
    }
}
