package cn.com.duiba.cloud.manage.service.api.model.enums.app;

import org.apache.commons.lang3.ObjectUtils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

/**
 * 租户应用状态枚举
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/29
 */
public enum TenantAppStateEnum {
    /** 应用状态 */
    NOT_START(0, "未开始"),
    NORMAL(1, "正常"),
    EXPIRED(2, "过期"),

    ;
    private Integer state;
    private String desc;

    TenantAppStateEnum(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByState(Integer state) {
        for (TenantAppStateEnum entity : TenantAppStateEnum.values()) {
            if (entity.state.equals(state)) {
                return entity.desc;
            }
        }
        return null;
    }

    public static Integer getStateByTime(Date startTime, Date endTime) {
        if (!ObjectUtils.allNotNull(startTime, endTime)) {
            return null;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        return getStateByTime(startTime.toInstant().atZone(zoneId).toLocalDateTime(), endTime.toInstant().atZone(zoneId).toLocalDateTime());
    }

    public static Integer getStateByTime(LocalDateTime startTime, LocalDateTime endTime) {
        if (!ObjectUtils.allNotNull(startTime, endTime)) {
            return null;
        }
        if (endTime.compareTo(startTime) < 0) {
            throw new IllegalStateException("开始时间不能大于结束时间");
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.compareTo(startTime) < 0) {
            return NOT_START.state;
        } else if (now.compareTo(endTime) <= 0) {
            return NORMAL.state;
        } else {
            return EXPIRED.state;
        }
    }


}
