package cn.com.duiba.cloud.manage.service.api.model.enums.mallapp;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author: 郑建豪
 * @date: 2022/6/6 16:01
 * @description: 权益类型
 */
@Getter
@AllArgsConstructor
public enum InterestTypeEnum {
    CREDITS_RATIO(1, "积分倍率"),
    SEND_CREDITS(2, "赠送积分"),
    CUSTOM(3, "自定义权益"),
    ;

    private Integer type;
    private String desc;

    public static String getDescByType(Integer type){
        if(null == type){
            return null;
        }
        for(InterestTypeEnum interestTypeEnum: InterestTypeEnum.values()){
            if(interestTypeEnum.getType().equals(type)){
                return interestTypeEnum.getDesc();
            }
        }
        return null;
    }

}
