package cn.com.duiba.cloud.manage.service.api.model.param.importdata;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;

import java.util.Date;

/**
 * @author linzhou
 * @ClassName RemoteImportRecordListRequest.java
 * @createTime 2021年11月29日 10:34:00
 * @Description
 */
public class RemoteImportRecordListRequest extends BaseParam {

    /**
     * 导入类型
     */
    private Byte type;

    /**
     * 应用程序id
     */
    private Long appId;

    /**
     * 导入时间范围
     */
    private Date startTime;
    /**
     * 导入时间范围
     */
    private Date endTime;


    /**
     * 当前页码。从1开始计数
     */
    private int pageNo;

    /**
     * 每页记录数
     */
    private int pageSize;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getOffset() {
        return (this.pageNo - 1) * this.pageSize;
    }
}
