package cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish;

import cn.com.duiba.cloud.manage.service.api.model.enums.mallfurnish.MallAppPagePublishTypeEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import cn.com.duiba.cloud.manage.service.api.utils.EnumValid;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 页面发布
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteMallAppPagePublishParam extends BaseParam {

    private static final long serialVersionUID = -4947409099563517410L;

    /**
     * 页面id
     */
    @NotNull(message = "页面id不能为空")
    private Long id;

    /**
     * 发布类型 0-普通发布 1-定时发布
     */
    @NotNull(message = "选择发布类型")
    @EnumValid(target = MallAppPagePublishTypeEnum.class, field = "type", message = "请选择正确的发布类型")
    private Integer publishType;

    /**
     * 定时发布时间
     */
    private Date publishTime;

    /**
     * 定时发布是否设置为首页 false/不设置 true/设置
     */
    private Boolean setIndex = false;
}
