package cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish;

import cn.com.duiba.cloud.manage.service.api.model.enums.mallfurnish.MallAppPageQueryPageStatusEnum;
import cn.com.duiba.cloud.manage.service.api.utils.EnumValid;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 页面分页查询
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/13
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RemoteMallAppPageQueryParam extends PageRequest {

    private static final long serialVersionUID = 2727814033046855364L;

    /**
     * 应用id
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * 页面id
     */
    private Long id;

    /**
     * 页面名称
     */
    @Size(max = 10, message = "页面名称不超过10个字符")
    private String pageTitle;

    /**
     * 查询的页面状态 0-未发布 1-已发布 2-定时发布
     */
    @EnumValid(target = MallAppPageQueryPageStatusEnum.class, message = "未知页面状态")
    private Integer queryPageStatus;

}
