package cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 修改短链明细请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 10:13
 * @since 0.0.7
 **/
@Data
@Accessors(chain = true)
public class RemoteUpdateShortLinkDetailParam implements Serializable {
    private static final long serialVersionUID = -984515072214947993L;

    /**
     * 明细id
     */
    @NotNull(message = "明细id不能为空")
    private Long id;

    /**
     * 转换状态(1:成功,2:失败,3:处理中)
     */
    private Integer conversionStatus;

    /**
     * 短链接
     */
    private String shortLink;
}
