package cn.com.duiba.cloud.manage.service.api.model.param.rights;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * @program: duiba-manage-erp
 * @description: 应用类型全部功能权益查询
 * @author: 郭云龙
 * @create: 2022-03-23 17:07
 **/
@Getter
@Setter
public class RemoteAppTypeRightsPageQueryParam extends PageRequest {

    /**
     * 应用类型ID
     */
    @NotNull(message = "应用类型ID不能为空")
    private Long appTypeId;

    /**
     * 二级权益ID，一般将一级权益当作页签使用
     */
    @NotNull(message = "权益ID不能为空")
    private Long rightsParentId;

    /**
     * 未订购可见开关
     * 0-关闭 1-打开
     */
    private Integer notOrderedVisibleSwitch;


}
