package cn.com.duiba.cloud.manage.service.api.model.param.rights;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/1 17:23
 */
@Getter
@Setter
public class RemoteOpenRecordRenewalParam extends BaseParam implements Serializable {

    /**
     * 订阅权益包ID-套餐版本/售卖包ID
     */
    @NotNull(message = "开通记录id不能为空")
    private Long tenantSubPkgId;

    /**
     * 服务时长ID
     */
    @NotNull(message = "服务时长ID不能为空")
    private Long serviceTimeId;

    /**
     * 服务开始日期
     */
    @NotNull(message = "服务开始日期不能为空")
    private Date serviceStartDate;

    /**
     * 赠送时长
     */
    private Long giftDuration;

    /**
     * 服务结束日期
     */
    private Date serviceEndDate;
}
