package cn.com.duiba.cloud.manage.service.api.model.param.store;

import cn.com.duiba.cloud.manage.service.api.model.enums.store.ShelfStateEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.PageBaseParam;
import cn.com.duiba.cloud.manage.service.api.utils.EnumValid;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/12 10:50
 */
@Getter
@Setter
public class RemoteStoreDiscountPageParam extends PageBaseParam {

    /**
     * 客户应用名
     */
    private String tenantAppName;

    /**
     * 上架状态 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.ShelfStateEnum}
     * 为空则表示查询全部
     */
    @EnumValid(target = ShelfStateEnum.class, message = "上架状态不合法")
    private Integer state;

    /**
     * 供应商应用id
     */
    @Max(value = Long.MAX_VALUE, message = "供应商应用id长度超过最大限制")
    private Long supplierAppId;

    /**
     * 供应商应用名称
     */
    private String supplierAppName;

    /**
     * 门店id
     */
    private Long storeId;
}
