package cn.com.duiba.cloud.manage.service.api.remoteservice.mallapp;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipConfDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipGradeDTO;

import java.util.List;

/**
 * @author zhengjianhao
 * @date 2022/3/29
 * @description 商城应用-会员配置
 */
@AdvancedFeignClient
@Deprecated
public interface RemoteMallAppVipConfService {

	/**
	 * 查询所有会员配置
	 */
	List<MallAppVipConfDTO> getVipConf(Long appId);

	/**
	 * 根据类型查询会员配置
	 */
	MallAppVipConfDTO getVipConfByType(Long appId, String vipType);

	/**
	 * 保存会员配置
	 */
	@Deprecated
	void saveVipConf(List<MallAppVipConfDTO> mallAppVipConfDTOList) throws BizException;

	/**
	 * 保存会员配置
	 */
	void saveVipConfSingle(MallAppVipConfDTO mallAppVipConfDTO) throws BizException;

	/**
	 * 根据vip类型和用户vip等级列表，获取该app下最高的vip
	 */
	@Deprecated
	String getUserVipLevel(Long appId, String vipTypeName, List<String> gradeDevTagList);

	/**
	 * 根据vip类型和用户vip等级列表，获取该app下最高的vip信息
	 */
	@Deprecated
	MallAppVipGradeDTO getUserVip(Long appId, String vipTypeName, List<String> gradeDevTagList);

}
