package cn.com.duiba.cloud.manage.service.api.remoteservice.mallfurnish;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppPageQueryDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppPageDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPageCancelPublishParam;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPageCopyParam;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPageDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPageDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPageEditParam;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPagePublishParam;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPageSaveParam;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.RemoteMallAppPageSetIndexParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 装修页面
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/13
 */
@AdvancedFeignClient
public interface RemoteMallAppPageService {

    /**
     * 页面分页查询
     * @param remoteParam
     * @return
     * @throws BizException
     */
    PageResponse<MallAppPageQueryDTO> pageQuery(RemoteMallAppPageQueryParam remoteParam) throws BizException;

    /**
     * 页面保存
     * @param remoteParam
     * @return
     * @throws BizException
     */
    Long save(RemoteMallAppPageSaveParam remoteParam) throws BizException;

    /**
     * 页面复制
     * @param remoteParam
     * @return
     * @throws BizException
     */
    Long copy(RemoteMallAppPageCopyParam remoteParam) throws BizException;

    /**
     * 页面编辑
     * @param remoteParam
     * @return
     * @throws BizException
     */
    Boolean edit(RemoteMallAppPageEditParam remoteParam) throws BizException;

    /**
     * 快照页面详情
     * @param remoteParam
     * @return
     * @throws BizException
     */
    MallAppPageDetailDTO snapshotDetail(RemoteMallAppPageDetailParam remoteParam) throws BizException;

    /**
     * 页面详情
     * @param id
     * @return
     * @throws BizException
     */
    MallAppPageDetailDTO pageDetail(Long id) throws BizException;

    /**
     * 首页详情
     * @return
     * @throws BizException
     */
    MallAppPageDetailDTO frontPageDetail(Long appId) throws BizException;

    /**
     * 预览详情
     * @param id
     * @return
     * @throws BizException
     */
    MallAppPageDetailDTO previewDetail(Long id) throws BizException;

    /**
     * 设置首页
     * @param remoteParam
     * @return
     * @throws BizException
     */
    Boolean setIndex(RemoteMallAppPageSetIndexParam remoteParam) throws BizException, InterruptedException;

    /**
     * 页面删除
     * @param remoteParam
     * @return
     * @throws BizException
     */
    Boolean delete(RemoteMallAppPageDeleteParam remoteParam) throws BizException;

    /**
     * 页面发布
     * @param remoteParam
     * @return
     * @throws BizException
     */
    Long publish(RemoteMallAppPagePublishParam remoteParam) throws BizException, InterruptedException;

    /**
     * 取消发布
     * @param remoteParam
     * @return
     * @throws BizException
     */
    Boolean cancelPublishTask(RemoteMallAppPageCancelPublishParam remoteParam) throws BizException;

}
