package cn.com.duiba.cloud.manage.service.api.remoteservice.mallfurnish;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallfurnish.MallAppUnitDto;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.MallAppUnitSearchParam;

import java.util.List;

/**
 * 页面组件表
 * @author kjj mybatis generator 
 * @date 2022-06-15
 */
@AdvancedFeignClient
public interface RemoteMallAppUnitService {
     
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 页面组件集合
     */
    List<MallAppUnitDto> selectList(MallAppUnitSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(MallAppUnitSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 页面组件
     */
    MallAppUnitDto selectById(Long id);

    /**
     * 新增
     *
     * @param entity 页面组件
     * @return 执行结果
     */
    Long insert(MallAppUnitDto entity);

    /**
     * 更新
     * @param entity 页面组件
     * @return 执行结果
     */
    int update(MallAppUnitDto entity);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id,String unitFlag);

    /**
     * 根据code数组查询
     * @param flags code
     * @return 页面组件
     */
    List<MallAppUnitDto> selectByFlags(List<String> flags);
}