package cn.com.duiba.cloud.manage.service.api.remoteservice.rights;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.OpenRecordDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.TenantAppDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.TenantSubPkgDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteCalculateEndTimeParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteOpenRecordAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteOpenRecordDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteOpenRecordDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteOpenRecordRenewalParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteOpenRecordUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteTenantAppDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteTenantSubPkgParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-03-28 17:39:46
*/
@AdvancedFeignClient
public interface RemoteTenantSubPkgService {

    /**
     * 分页查询开通记录
     * @param param 查询参数
     * @return PageResponse<TenantSubPkgDTO>
     */
    PageResponse<TenantSubPkgDTO> openRecordList(RemoteTenantSubPkgParam param);

    /**
     * 根据id查询开通记录详情
     * @param param 查询参数
     * @return OpenRecordDetailDTO
     * @throws BizException 查询异常
     */
    OpenRecordDetailDTO openRecordDetail(RemoteOpenRecordDetailParam param) throws BizException;

    /**
     * 批量查询应用开通数量
     * @param list 查询参数
     * @return 开通数量
     */
    Map<Long, Integer> getByPkgIdList(List<Long> list);

    /**
     * 套餐版本/售卖包开通
     *
     * @param param 开通参数
     * @throws BizException 开通异常
     * @throws InterruptedException 并发加锁异常
     */
    void openRecordAdd(RemoteOpenRecordAddParam param) throws BizException, InterruptedException;

    /**
     * 根据tenantAppId查询应用的基础信息
     * @param param 查询参数
     * @return TenantAppDetailDTO
     * @throws BizException 查询异常
     */
    TenantAppDetailDTO tenantAppDetail(RemoteTenantAppDetailParam param) throws BizException;

    /**
     * 计算服务结束时间
     * @param param 查询参数
     * @return 服务结束时间
     * @throws BizException 计算异常
     */
    Date calculateEndTime(RemoteCalculateEndTimeParam param) throws BizException;

    /**
     * 套餐版本/售卖包续费
     *
     * @param param 续费参数
     * @throws BizException 续费异常
     * @throws InterruptedException 并发加锁异常
     */
    void openRecordRenewal(RemoteOpenRecordRenewalParam param) throws BizException, InterruptedException;


    /**
     * 套餐版本/售卖包编辑
     *
     * @param param 编辑参数
     * @throws BizException 编辑异常
     * @throws InterruptedException 并发加锁异常
     */
    void openRecordUpdate(RemoteOpenRecordUpdateParam param) throws BizException, InterruptedException;

    /**
     * 删除套餐/售卖包
     * @param param 删除参数
     * @throws BizException 删除异常
     * @throws InterruptedException 并发加锁异常
     */
    void openRecordDelete(RemoteOpenRecordDeleteParam param) throws BizException, InterruptedException;
}
