/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipGradeDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.mallapp.VipGradeEnum;
import cn.com.duiba.wolf.entity.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class VipLevelUtil {
    public static MallAppVipGradeDTO matchLevelConfByGrowthValue(Long growthValue, List<MallAppVipGradeDTO> mallAppVipLevelConfDtoList) {
        if (CollectionUtils.isEmpty(mallAppVipLevelConfDtoList)) {
            return null;
        }
        MallAppVipGradeDTO baseLevelConf = VipLevelUtil.getBaseLevelConf(mallAppVipLevelConfDtoList);
        if (null == growthValue || growthValue <= 0L) {
            return baseLevelConf;
        }
        MallAppVipGradeDTO matchedLevelConf = null;
        mallAppVipLevelConfDtoList.sort(Comparator.comparing(MallAppVipGradeDTO::getGrade).reversed());
        for (MallAppVipGradeDTO levelConfDTO : mallAppVipLevelConfDtoList) {
            if (growthValue < levelConfDTO.getUpgradeGrowthValue()) continue;
            matchedLevelConf = levelConfDTO;
            break;
        }
        if (null == matchedLevelConf) {
            matchedLevelConf = baseLevelConf;
        }
        return matchedLevelConf;
    }

    public static Pair<MallAppVipGradeDTO, MallAppVipGradeDTO> getCurrentOldAndHigherConf(Integer grade, List<MallAppVipGradeDTO> mallAppVipLevelConfDtoList) {
        if (CollectionUtils.isEmpty(mallAppVipLevelConfDtoList)) {
            return Pair.from(null, null);
        }
        MallAppVipGradeDTO oldLevelCurrentConf = null;
        MallAppVipGradeDTO higherLevelConf = null;
        mallAppVipLevelConfDtoList.sort(Comparator.comparing(MallAppVipGradeDTO::getGrade));
        for (MallAppVipGradeDTO levelConfDTO : mallAppVipLevelConfDtoList) {
            if (grade.equals(levelConfDTO.getGrade())) {
                oldLevelCurrentConf = levelConfDTO;
            }
            if (grade >= levelConfDTO.getGrade()) continue;
            higherLevelConf = levelConfDTO;
            break;
        }
        return Pair.from(oldLevelCurrentConf, higherLevelConf);
    }

    public static MallAppVipGradeDTO getLowerLevelConf(Integer grade, List<MallAppVipGradeDTO> mallAppVipLevelConfDtoList) {
        if (CollectionUtils.isEmpty(mallAppVipLevelConfDtoList)) {
            return null;
        }
        MallAppVipGradeDTO matchedLevelConf = null;
        mallAppVipLevelConfDtoList.sort(Comparator.comparing(MallAppVipGradeDTO::getGrade).reversed());
        for (MallAppVipGradeDTO levelConfDTO : mallAppVipLevelConfDtoList) {
            if (grade <= levelConfDTO.getGrade()) continue;
            matchedLevelConf = levelConfDTO;
            break;
        }
        if (null == matchedLevelConf) {
            matchedLevelConf = VipLevelUtil.getBaseLevelConf(mallAppVipLevelConfDtoList);
        }
        return matchedLevelConf;
    }

    public static MallAppVipGradeDTO getBaseLevelConf(List<MallAppVipGradeDTO> mallAppVipLevelConfDtoList) {
        if (CollectionUtils.isEmpty(mallAppVipLevelConfDtoList)) {
            return null;
        }
        return mallAppVipLevelConfDtoList.stream().filter(x -> Objects.equals(x.getGrade(), VipGradeEnum.GRADE_0.getGrade())).findFirst().orElse(null);
    }
}

