package cn.com.duiba.cloud.manage.service.api.model.param.app;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 租户应用分页查询参数
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/29
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteTenantAppPageQueryParam extends PageRequest {

    private static final long serialVersionUID = 1111321138911203740L;

    /**
     * 租户应用id
     */
    private Long tenantAppId;

    /**
     * 租户应用名称
     */
    private String tenantAppName;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 管理员手机号
     */
    private String adminPhone;

    /**
     * 业务主体
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.BusinessEntityEnum
     */
    private Long businessEntityId;

    /**
     * 应用类型 - tb_app_type表的id
     */
    private Long appTypeId;

    /**
     * 应用版本 - tb_rights_pkg表的id
     */
    private Long pkgId;

    /**
     * 应用状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.app.TenantAppStateEnum
     */
    private Integer appState;

    /**
     * 应用标签
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.TenantAppTagEnum
     */
    private Long tenantAppTag;


}
