package cn.com.duiba.cloud.manage.service.api.remoteservice.mallapp;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipInterestConfDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.mallapp.InterestPageRequest;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author: 郑建豪
 * @date: 2022/6/7 21:09
 * @description: 商城的等级权益配置
 */
@AdvancedFeignClient
public interface RemoteMallAppVipInterestConfService {

	/**
	 * 分页查询
	 */
	PageResponse<MallAppVipInterestConfDTO> pageQuery(InterestPageRequest param) throws BizException;

	/**
	 * 根据权益id列表批量查询：限量2000条
	 */
	List<MallAppVipInterestConfDTO> getListByIds(List<Long> interestIdList);

	/**
	 * 根据权益id查询
	 */
	MallAppVipInterestConfDTO getById(Long interestId);

	/**
	 * 新增权益
	 */
	void addInterest(MallAppVipInterestConfDTO dto) throws BizException;

	/**
	 * 编辑权益
	 */
	void editInterest(MallAppVipInterestConfDTO dto) throws BizException;

	/**
	 * 删除权益
	 */
	void deleteInterest(Long interestId);

}
