package cn.com.duiba.cloud.manage.service.autologin.sdk.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 配置
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/24
 */
@Data
@ConfigurationProperties(prefix = "duiba.openapi")
public class AutoLoginProperties {

    /**
     * 要拦截的url，配置多个地址用","分隔
     * 若没配置，就采用默认值/** 拦截所有
     */
    private String pathPatterns = "/**";

    /**
     * 排除的路径，拦截器不拦截，配置多个地址用","分隔
     */
    private String excludePathPatterns;

    /**
     * 应用过期跳转的路径
     */
    private String tenantAppOverdueRedirectUrl;

}
