package cn.com.duiba.cloud.manage.service.autologin.sdk.config;

import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.AutoLoginInterceptor;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.AutoLoginInterceptorHandlerManager;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.LoginInterceptor;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.TenantAppOverdueHandler;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.TenantAppTradeLimitHandler;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.CommonVerification;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.impl.CommonVerificationImpl;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拦截器配置
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/24
 */
@Configuration
@Order(-1)
@EnableConfigurationProperties(AutoLoginProperties.class)
public class AutoLoginSdkConfiguration implements WebMvcConfigurer {

    @Resource
    private AutoLoginProperties properties;

    private static final List<String> DEFAULT_EXCLUDE_PATHS = Lists.newArrayList();

    static {
        DEFAULT_EXCLUDE_PATHS.add("/error");
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = properties.getPathPatterns();
        String[] paths = StringUtils.split(pathPatterns, ",");

        String excludePathPatterns = properties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{}
                : StringUtils.split(excludePathPatterns, ",");

        AutoLoginInterceptor autoLoginInterceptor = openApiInterceptor();
        registry.addInterceptor(autoLoginInterceptor)
                .addPathPatterns(paths)
                .excludePathPatterns(excludePath)
                .excludePathPatterns(DEFAULT_EXCLUDE_PATHS);
    }

    @Bean
    @ConditionalOnProperty(prefix = "duiba.openapi.interceptor", value = "login", havingValue = "true", matchIfMissing = true)
    public LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public AutoLoginInterceptorHandlerManager openApiInterceptorHandlerManager() {
        return new AutoLoginInterceptorHandlerManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public AutoLoginInterceptor openApiInterceptor() {
        return new AutoLoginInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantAppOverdueHandler tenantAppOverdueHandler() {
        return new TenantAppOverdueHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantAppTradeLimitHandler tenantAppTradeLimitHandler() {
        return new TenantAppTradeLimitHandler();
    }


    @Bean
    @ConditionalOnMissingBean
    public CommonVerification permissionVerificationRemote() {
        return new CommonVerificationImpl();
    }

}
